<?php

namespace app\models;

use yii\base\Model;

class RegisterForm extends Model
{

    public $surname;
    public $name;
    public $patronymic;
    public $username;
    public $email;
    public $phone_number;
    public $password;
    public $password_repeat;

    public function rules()
    {
        return [
            [['surname', 'name', 'username', 'email', 'phone_number', 'password', 'password_repeat'], 'required'],
            [['name', 'surname', 'patronymic'], 'match', 'pattern' => '/^[а-яё\s\-]+$/iu', 'message' => 'Разрешены только кириллические символы, пробелы'],
            ['password', 'string', 'min' => 8],
            ['password_repeat', 'compare', 'compareAttribute' => 'password', 'message' => 'Пароли не совпадают'],
            ['username', 'string', 'min' => 5],
            ['email', 'email'],
        ];
    }

    public function attributeLabels()
    {
        return [
            'surname' => 'Фамилия',
            'name' => 'Имя',
            'patronymic' => 'Отчество',
            'username' => 'Логин',
            'email' => 'Email',
            'phone_number' => 'Номер телефона',
            'password' => 'Пароль',
            'password_repeat' => 'Повторите пароль'
        ];
    }

    public function signup()
    {
        if (!$this->validate()) {
            return null;
        }

        $user = new User();
        $user->surname = $this->surname;
        $user->name = $this->name;
        $user->patronymic = $this->patronymic;
        $user->username = $this->username;
        $user->email = $this->email;
        $user->phone_number = $this->phone_number;
        $user->setPassword($this->password);

        return $user->save() ? $user : null;
    }
}

